/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.text.Strings;

public class ConstraintViolationException
extends UserFacingException {
    private static final long serialVersionUID = -6719912119648996815L;
    Object context;
    ConfigKey<?> key;
    Object value;

    public ConstraintViolationException(String message) {
        super(message);
    }

    public ConstraintViolationException(String message, Throwable cause) {
        super(message, cause);
    }

    public ConstraintViolationException(Throwable cause) {
        super(cause);
    }

    public static ConstraintViolationException of(Throwable e, Object context, ConfigKey<?> key, Object value) {
        if (e instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)((Object)e);
            if (cve.value == null && (cve.context != null || cve.key != null)) {
                cve.value = value;
            }
            if (cve.context == null) {
                cve.context = context;
            }
            if (cve.key == null) {
                cve.key = key;
            }
            if (Objects.equals(context, cve.context) && Objects.equals(key, cve.key)) {
                return cve;
            }
        }
        return new ConstraintViolationException(e).with(context, key, value);
    }

    public Object getContext() {
        return this.context;
    }

    public ConfigKey<?> getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public ConstraintViolationException with(Object context, ConfigKey<?> key, Object value) {
        this.setContext(context);
        this.setKey(key);
        this.setValue(value);
        return this;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public void setKey(ConfigKey<?> key) {
        this.key = key;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getSuppliedMessage() {
        return super.getMessage();
    }

    public String getMessage() {
        String supplied = this.getSuppliedMessage();
        String cause = Exceptions.collapseText((Throwable)this.getCause());
        supplied = cause.contains(supplied) ? cause : supplied + "; caused by: " + cause;
        MutableList output = MutableList.of();
        output.add("Invalid value");
        if (this.key != null && !Strings.containsLiteralAsWord((String)supplied, (String)this.key.getName())) {
            output.add(" for key '" + this.key.getName() + "'");
        }
        if (this.context != null && !Strings.containsLiteralAsWord((String)supplied, (String)("" + this.context))) {
            output.add(" on " + this.context);
        }
        if (this.key != null && !Strings.containsLiteralAsWord((String)supplied, (String)("" + this.value))) {
            output.add(" " + (this.value == null ? "(value is null)" : ": '" + this.value + "'"));
        }
        if (supplied != null) {
            if (output.size() == 1) {
                output = MutableList.of((Object)supplied);
            } else {
                output.add("; ");
                output.add(supplied);
            }
        }
        return Strings.join((Iterable)output, (String)"");
    }

    public static class CompoundConstraintViolationException
    extends ConstraintViolationException {
        private final Collection<Throwable> allViolations;

        protected CompoundConstraintViolationException(String message, Collection<Throwable> causes) {
            super(message, causes.iterator().next());
            this.allViolations = causes;
        }

        public static CompoundConstraintViolationException of(Object source, Map<ConfigKey<?>, Throwable> violations) {
            Set<Object> contexts;
            Set<ConstraintViolationException> cves = CompoundConstraintViolationException.getCVEs(violations.values());
            StringBuilder message = new StringBuilder();
            if (source != null) {
                message.append("Error configuring ").append(source).append(": ");
            }
            if (violations.size() == 1) {
                message.append(Exceptions.collapseText((Throwable)((Throwable)Iterables.getOnlyElement(violations.values()))));
            } else {
                MutableSet keys = MutableSet.copyOf(CompoundConstraintViolationException.getConfigKeys(cves)).putAll(violations.keySet());
                if (keys.size() > 1) {
                    message.append("Invalid values for " + keys.stream().map(ConfigKey::getName).collect(Collectors.toSet()) + ": ");
                }
                if (!violations.isEmpty()) {
                    message.append(violations.values().stream().map(Throwable::toString).collect(Collectors.toSet()));
                }
            }
            CompoundConstraintViolationException result = new CompoundConstraintViolationException(message.toString(), violations.values());
            result.setContext(source);
            if ((source instanceof String || source == null) && (contexts = CompoundConstraintViolationException.getContexts(cves)).size() == 1) {
                result.setContext(Iterables.getOnlyElement(contexts));
            }
            return result;
        }

        private static Set<ConstraintViolationException> getCVEs(Collection<? extends Throwable> violations) {
            return violations.stream().filter(t -> t instanceof ConstraintViolationException).collect(Collectors.toSet());
        }

        private static Set<ConfigKey<?>> getConfigKeys(Collection<? extends Throwable> violations) {
            return CompoundConstraintViolationException.getCVEs(violations).stream().map(ConstraintViolationException::getKey).collect(Collectors.toSet());
        }

        private static Set<Object> getContexts(Collection<? extends Throwable> violations) {
            return CompoundConstraintViolationException.getCVEs(violations).stream().map(ConstraintViolationException::getContext).collect(Collectors.toSet());
        }

        public Set<ConstraintViolationException> getCVEs() {
            return CompoundConstraintViolationException.getCVEs(this.getAllViolations());
        }

        public Set<ConfigKey<?>> getConfigKeys() {
            return CompoundConstraintViolationException.getConfigKeys(this.getAllViolations());
        }

        public Set<Object> getContexts() {
            return CompoundConstraintViolationException.getContexts(this.getAllViolations());
        }

        public Collection<Throwable> getAllViolations() {
            return this.allViolations;
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + ": " + this.getMessage();
        }
    }
}

