/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;

public class OverLimitParser
implements Function<String, Map<String, String>> {
    @Resource
    private Logger logger = Logger.NULL;
    private final Json json;

    @Inject
    public OverLimitParser(Json json) {
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
    }

    public Map<String, String> apply(String in) {
        try {
            return ((Holder)this.json.fromJson((String)in, Holder.class)).overLimit;
        }
        catch (RuntimeException e) {
            this.logger.error("Failed to parse " + in + "", new Object[]{e});
            return ImmutableMap.of();
        }
    }

    private static class Holder {
        Map<String, String> overLimit = ImmutableMap.of();

        private Holder() {
        }
    }
}

