/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.atmos.filters.ShareUrl;
import org.jclouds.atmos.functions.AtmosObjectName;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;

@Singleton
public class ObjectToBlobMetadata
implements Function<AtmosObject, MutableBlobMetadata> {
    private final AtmosObjectName objectName;
    private final ShareUrl shareUrl;
    private static final Set<String> systemMetadata = ImmutableSet.of((Object)"atime", (Object)"mtime", (Object)"ctime", (Object)"itime", (Object)"type", (Object)"uid", (Object[])new String[]{"gid", "objectid", "objname", "size", "nlink", "policyname"});

    @Inject
    protected ObjectToBlobMetadata(AtmosObjectName objectName, ShareUrl shareUrl) throws SecurityException, NoSuchMethodException {
        this.objectName = objectName;
        this.shareUrl = shareUrl;
    }

    public MutableBlobMetadata apply(AtmosObject from) {
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        to.setId(from.getSystemMetadata().getObjectID());
        to.setLastModified(from.getSystemMetadata().getLastUserDataModification());
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)to.getContentMetadata());
        to.setName(this.objectName.apply(from));
        to.setUri(from.getContentMetadata().getUri());
        to.setContainer((String)Iterables.get((Iterable)Splitter.on((char)'/').split((CharSequence)from.getContentMetadata().getPath()), (int)0));
        if (from.getAllHeaders().containsEntry((Object)"x-emc-groupacl", (Object)"other=READ")) {
            to.setPublicUri(this.shareUrl.apply(from.getContentMetadata().getPath()));
        }
        if (from.getSystemMetadata().getType() == FileType.DIRECTORY) {
            to.setType((Enum)StorageType.FOLDER);
        } else {
            to.setType((Enum)StorageType.BLOB);
        }
        HashMap lowerKeyMetadata = Maps.newHashMap();
        for (Map.Entry<String, String> entry : from.getUserMetadata().getMetadata().entrySet()) {
            String key = entry.getKey().toLowerCase();
            if (systemMetadata.contains(key)) continue;
            lowerKeyMetadata.put(key, entry.getValue());
        }
        to.setUserMetadata((Map)lowerKeyMetadata);
        to.setSize(from.getContentMetadata().getContentLength());
        to.setTier(Tier.STANDARD);
        to.setETag(from.getSystemMetadata().getObjectID());
        to.getContentMetadata().setContentMD5(from.getSystemMetadata().getContentMD5());
        return to;
    }
}

