/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.couchbase;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolverManager;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.drivers.downloads.BasicDownloadRequirement;
import org.apache.brooklyn.core.entity.drivers.downloads.DownloadProducerFromUrlAttribute;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseCluster;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseClusterImpl;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseNode;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseNodeDriver;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseNodeImpl;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.NaturalOrderComparator;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;

public class CouchbaseNodeSshDriver
extends AbstractSoftwareProcessSshDriver
implements CouchbaseNodeDriver {
    public CouchbaseNodeSshDriver(CouchbaseNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public static String couchbaseCli(String cmd) {
        return "/opt/couchbase/bin/couchbase-cli " + cmd + " ";
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        if (!osDetails.isLinux()) {
            Tasks.markInessential();
            throw new IllegalStateException("Unsupported OS for installing Couchbase. Will continue but may fail later.");
        }
        List<String> commands = this.installLinux(urls, saveAs);
        this.newScript((String)"installing").body.append(commands).execute();
    }

    private List<String> installLinux(List<String> urls, String saveAs) {
        log.info("Installing " + this.getEntity() + " using couchbase-server-{} {}", (Object)this.getCommunityOrEnterprise(), (Object)this.getVersion());
        String apt = BashCommands.chainGroup((String[])new String[]{BashCommands.installPackage((Map)MutableMap.of((Object)"apt", (Object)"python-httplib2 libssl0.9.8"), null), BashCommands.sudo((String)String.format("dpkg -i %s", saveAs))});
        String yum = BashCommands.chainGroup((String[])new String[]{"which yum", BashCommands.ok((String)BashCommands.sudo((String)"sed -i.bk s/^enabled=1$/enabled=0/ /etc/yum/pluginconf.d/subscription-manager.conf")), BashCommands.ok((String)BashCommands.sudo((String)"yum check-update")), BashCommands.sudo((String)"yum install -y pkgconfig"), BashCommands.sudo((String)"[ -f /etc/redhat-release ] && (grep -i \"red hat\" /etc/redhat-release && sudo yum install -y openssl098e) || :"), BashCommands.sudo((String)String.format("rpm --install %s", saveAs))});
        String link = (String)new DownloadProducerFromUrlAttribute().apply((DownloadResolverManager.DownloadRequirement)new BasicDownloadRequirement((EntityDriver)this)).getPrimaryLocations().iterator().next();
        return ImmutableList.builder().add((Object)BashCommands.INSTALL_CURL).addAll(Arrays.asList(BashCommands.INSTALL_CURL, BashCommands.require((String)BashCommands.alternatives((String[])new String[]{BashCommands.simpleDownloadUrlAs(urls, (String)saveAs), "curl -f -L -k " + StringEscapes.BashStringEscapes.wrapBash((String)link) + " -H 'Referer: http://www.couchbase.com/downloads' -o " + saveAs}), (String)("Could not retrieve " + saveAs + " (from " + urls.size() + " sites)"), (int)9))).add((Object)BashCommands.alternatives((String[])new String[]{apt, yum})).build();
    }

    public void customize() {
    }

    public void launch() {
        String clusterPrefix = "--cluster-" + (this.isPreV3() ? "init-" : "");
        this.newScript((String)"launching").body.append(new CharSequence[]{BashCommands.sudo((String)"/etc/init.d/couchbase-server start"), "for i in {0..120}\ndo\n    if [ $i -eq 120 ]; then echo REST API unavailable after 120 seconds, failing; exit 1; fi;\n    curl -s " + String.format("http://localhost:%s", this.getWebPort()) + " > /dev/null && echo REST API available after $i seconds && break\n    sleep 1\ndone\n" + CouchbaseNodeSshDriver.couchbaseCli("cluster-init") + (this.isPreV3() ? this.getCouchbaseHostnameAndPort() : this.getCouchbaseHostnameAndCredentials()) + " " + clusterPrefix + "username=" + this.getUsername() + " " + clusterPrefix + "password=" + this.getPassword() + " " + clusterPrefix + "port=" + this.getWebPort() + " " + clusterPrefix + "ramsize=" + this.getClusterInitRamSize()}).execute();
    }

    public boolean isRunning() {
        return this.newScript((String)"check-running").body.append((CharSequence)String.format("curl -u %s:%s http://localhost:%s/pools/nodes", this.getUsername(), this.getPassword(), this.getWebPort())).execute() == 0;
    }

    public void stop() {
        this.newScript((String)"stopping").body.append((CharSequence)BashCommands.sudo((String)"/etc/init.d/couchbase-server stop")).execute();
    }

    public String getVersion() {
        return (String)this.entity.getConfig(CouchbaseNode.SUGGESTED_VERSION);
    }

    @Override
    public String getOsTag() {
        return this.newDownloadLinkSegmentComputer().getOsTag();
    }

    protected DownloadLinkSegmentComputer newDownloadLinkSegmentComputer() {
        return new DownloadLinkSegmentComputer(this.getLocation().getOsDetails(), !this.isPreV3(), Strings.toString((Object)this.getEntity()));
    }

    @Override
    public String getDownloadLinkOsTagWithPrefix() {
        return this.newDownloadLinkSegmentComputer().getOsTagWithPrefix();
    }

    @Override
    public String getDownloadLinkPreVersionSeparator() {
        return this.newDownloadLinkSegmentComputer().getPreVersionSeparator();
    }

    private boolean isPreV3() {
        return NaturalOrderComparator.INSTANCE.compare((String)this.getEntity().getConfig(CouchbaseNode.SUGGESTED_VERSION), "3.0") < 0;
    }

    @Override
    public String getCommunityOrEnterprise() {
        Boolean isEnterprise = (Boolean)this.getEntity().getConfig(CouchbaseNode.USE_ENTERPRISE);
        return isEnterprise != false ? "enterprise" : "community";
    }

    private String getUsername() {
        return (String)this.entity.getConfig(CouchbaseNode.COUCHBASE_ADMIN_USERNAME);
    }

    private String getPassword() {
        return (String)this.entity.getConfig(CouchbaseNode.COUCHBASE_ADMIN_PASSWORD);
    }

    private String getWebPort() {
        return "" + this.entity.getAttribute((AttributeSensor)CouchbaseNode.COUCHBASE_WEB_ADMIN_PORT);
    }

    private String getCouchbaseHostnameAndCredentials() {
        return String.format("-c %s:%s -u %s -p %s", this.getSubnetHostname(), this.getWebPort(), this.getUsername(), this.getPassword());
    }

    private String getCouchbaseHostnameAndPort() {
        return String.format("-c %s:%s", this.getSubnetHostname(), this.getWebPort());
    }

    private String getClusterInitRamSize() {
        return ((Integer)this.entity.getConfig(CouchbaseNode.COUCHBASE_CLUSTER_INIT_RAM_SIZE)).toString();
    }

    @Override
    public void rebalance() {
        this.entity.sensors().set(CouchbaseNode.REBALANCE_STATUS, (Object)"explicitly started");
        this.newScript((String)"rebalance").body.append((CharSequence)(CouchbaseNodeSshDriver.couchbaseCli("rebalance") + this.getCouchbaseHostnameAndCredentials())).failOnNonZeroResultCode().execute();
        Repeater.create().backoff(Repeater.DEFAULT_REAL_QUICK_PERIOD, 2.0, Duration.millis((Number)500)).limitTimeTo(Duration.THIRTY_SECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (HostAndPort nodeHostAndPort : CouchbaseNodeSshDriver.this.getNodesHostAndPort()) {
                    if (!CouchbaseNodeSshDriver.this.isNodeRebalancing(nodeHostAndPort.toString())) continue;
                    return true;
                }
                return false;
            }
        }).run();
        this.entity.sensors().set(CouchbaseNode.REBALANCE_STATUS, (Object)"waiting for completion");
        Task reBalance = TaskBuilder.builder().displayName("Waiting until node is rebalancing").body((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Repeater.create().backoff(Duration.ONE_SECOND, 1.2, Duration.TEN_SECONDS).limitTimeTo(Duration.FIVE_MINUTES).until((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (HostAndPort nodeHostAndPort : CouchbaseNodeSshDriver.this.getNodesHostAndPort()) {
                            if (!CouchbaseNodeSshDriver.this.isNodeRebalancing(nodeHostAndPort.toString())) continue;
                            return false;
                        }
                        return true;
                    }
                }).run();
            }
        }).build();
        Boolean completed = (Boolean)DynamicTasks.queueIfPossible((TaskAdaptable)reBalance).orSubmitAndBlock().andWaitForSuccess();
        if (completed.booleanValue()) {
            this.entity.sensors().set(CouchbaseNode.REBALANCE_STATUS, (Object)"completed");
            ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this.getEntity(), (String)"rebalancing");
            log.info("Rebalanced cluster via primary node {}", (Object)this.getEntity());
        } else {
            this.entity.sensors().set(CouchbaseNode.REBALANCE_STATUS, (Object)"timed out");
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this.getEntity(), (String)"rebalancing", (Object)"rebalance did not complete within time limit");
            log.warn("Timeout rebalancing cluster via primary node {}", (Object)this.getEntity());
        }
    }

    private Iterable<HostAndPort> getNodesHostAndPort() {
        Group group = (Group)Iterables.getFirst((Iterable)this.getEntity().groups(), null);
        if (group == null) {
            return Lists.newArrayList();
        }
        return Iterables.transform((Iterable)((Iterable)group.getAttribute(CouchbaseCluster.COUCHBASE_CLUSTER_UP_NODES)), (Function)new Function<Entity, HostAndPort>(){

            public HostAndPort apply(Entity input) {
                return BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)input, (int)((Integer)input.getAttribute((AttributeSensor)CouchbaseNode.COUCHBASE_WEB_ADMIN_PORT)));
            }
        });
    }

    private boolean isNodeRebalancing(String nodeHostAndPort) {
        HttpToolResponse response = this.getApiResponse("http://" + nodeHostAndPort + "/pools/default/rebalanceProgress");
        if (response.getResponseCode() != 200) {
            throw new IllegalStateException("failed retrieving rebalance status: " + response);
        }
        return !"none".equals(HttpValueFunctions.jsonContents((String)"status", String.class).apply((Object)response));
    }

    private HttpToolResponse getApiResponse(String uri) {
        return HttpTool.httpGet((HttpClient)HttpTool.httpClientBuilder().uri(uri).credentials((Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword())).build(), (URI)URI.create(uri), (Map)ImmutableMap.of());
    }

    @Override
    public void serverAdd(String serverToAdd, String username, String password) {
        this.newScript((String)"serverAdd").body.append((CharSequence)(CouchbaseNodeSshDriver.couchbaseCli("server-add") + this.getCouchbaseHostnameAndCredentials() + " --server-add=" + StringEscapes.BashStringEscapes.wrapBash((String)serverToAdd) + " --server-add-username=" + StringEscapes.BashStringEscapes.wrapBash((String)username) + " --server-add-password=" + StringEscapes.BashStringEscapes.wrapBash((String)password))).failOnNonZeroResultCode().execute();
    }

    @Override
    public void serverAddAndRebalance(String serverToAdd, String username, String password) {
        this.newScript((String)"serverAddAndRebalance").body.append((CharSequence)(CouchbaseNodeSshDriver.couchbaseCli("rebalance") + this.getCouchbaseHostnameAndCredentials() + " --server-add=" + StringEscapes.BashStringEscapes.wrapBash((String)serverToAdd) + " --server-add-username=" + StringEscapes.BashStringEscapes.wrapBash((String)username) + " --server-add-password=" + StringEscapes.BashStringEscapes.wrapBash((String)password))).failOnNonZeroResultCode().execute();
        this.entity.sensors().set(CouchbaseNode.REBALANCE_STATUS, (Object)"triggered as part of server-add");
    }

    @Override
    public void bucketCreate(String bucketName, String bucketType, Integer bucketPort, Integer bucketRamSize, Integer bucketReplica) {
        log.info("Adding bucket: {} to cluster {} primary node: {}", new Object[]{bucketName, CouchbaseClusterImpl.getClusterOrNode((Entity)this.getEntity()), this.getEntity()});
        this.newScript((String)"bucketCreate").body.append((CharSequence)(CouchbaseNodeSshDriver.couchbaseCli("bucket-create") + this.getCouchbaseHostnameAndCredentials() + " --bucket=" + StringEscapes.BashStringEscapes.wrapBash((String)bucketName) + " --bucket-type=" + StringEscapes.BashStringEscapes.wrapBash((String)bucketType) + " --bucket-port=" + bucketPort + " --bucket-ramsize=" + bucketRamSize + " --bucket-replica=" + bucketReplica)).failOnNonZeroResultCode().execute();
    }

    @Override
    public void addReplicationRule(Entity toCluster, String fromBucket, String toBucket) {
        ((Task)DynamicTasks.queue((TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)toCluster, (AttributeSensor)Attributes.SERVICE_UP))).getUnchecked();
        String destName = CouchbaseClusterImpl.getClusterName(toCluster);
        log.info("Setting up XDCR for " + fromBucket + " from " + CouchbaseClusterImpl.getClusterName((Entity)this.getEntity()) + " (via " + this.getEntity() + ") to " + destName + " (" + toCluster + ")");
        Entity destPrimaryNode = (Entity)toCluster.getAttribute(CouchbaseCluster.COUCHBASE_PRIMARY_NODE);
        String destHostname = (String)destPrimaryNode.getAttribute(Attributes.HOSTNAME);
        String destUsername = (String)toCluster.getConfig(CouchbaseNode.COUCHBASE_ADMIN_USERNAME);
        String destPassword = (String)toCluster.getConfig(CouchbaseNode.COUCHBASE_ADMIN_PASSWORD);
        DynamicTasks.queue((TaskAdaptable)TaskTags.markInessential((TaskAdaptable)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{CouchbaseNodeSshDriver.couchbaseCli("xdcr-setup") + this.getCouchbaseHostnameAndCredentials() + " --create --xdcr-cluster-name=" + StringEscapes.BashStringEscapes.wrapBash((String)destName) + " --xdcr-hostname=" + StringEscapes.BashStringEscapes.wrapBash((String)destHostname) + " --xdcr-username=" + StringEscapes.BashStringEscapes.wrapBash((String)destUsername) + " --xdcr-password=" + StringEscapes.BashStringEscapes.wrapBash((String)destPassword)}).summary("create xdcr destination " + destName)).newTask()));
        DynamicTasks.queue((TaskAdaptable)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{CouchbaseNodeSshDriver.couchbaseCli("xdcr-replicate") + this.getCouchbaseHostnameAndCredentials() + " --create --xdcr-cluster-name=" + StringEscapes.BashStringEscapes.wrapBash((String)destName) + " --xdcr-from-bucket=" + StringEscapes.BashStringEscapes.wrapBash((String)fromBucket) + " --xdcr-to-bucket=" + StringEscapes.BashStringEscapes.wrapBash((String)toBucket)}).summary("configure replication for " + fromBucket + " to " + destName + ":" + toBucket)).newTask());
    }

    public static class DownloadLinkSegmentComputer {
        @Nullable
        private final OsDetails os;
        @Nonnull
        private final boolean isV3OrLater;
        @Nonnull
        private final String context;
        @Nonnull
        private final String osName;
        @Nonnull
        private final boolean isRpm;
        @Nonnull
        private final boolean is64bit;

        public DownloadLinkSegmentComputer(@Nullable OsDetails os, boolean isV3OrLater, @Nonnull String context) {
            this.os = os;
            this.isV3OrLater = isV3OrLater;
            this.context = context;
            if (os == null) {
                AbstractSoftwareProcessSshDriver.log.warn("No details known for OS of " + context + "; assuming 64-bit RPM distribution of Couchbase");
                this.osName = "centos";
                this.isRpm = true;
                this.is64bit = true;
                return;
            }
            this.osName = os.getName().toLowerCase();
            this.isRpm = !this.osName.contains("deb") && !this.osName.contains("ubuntu");
            this.is64bit = os.is64bit();
        }

        public String getPreVersionSeparator() {
            if (!this.isV3OrLater) {
                return "_";
            }
            if (this.isRpm) {
                return "-";
            }
            return "_";
        }

        public String getOsTag() {
            String fileExtension;
            String family;
            if (this.osName.contains("debian")) {
                family = "debian7_";
            } else if (this.osName.contains("ubuntu")) {
                family = "ubuntu12.04_";
            } else if (this.osName.contains("centos") || this.osName.contains("rhel") || this.osName.contains("red") && this.osName.contains("hat")) {
                family = "centos6.";
            } else {
                AbstractSoftwareProcessSshDriver.log.warn("Unrecognised OS " + this.os + " of " + this.context + "; assuming RPM distribution of Couchbase");
                family = "centos6.";
            }
            if (!this.is64bit && !this.isV3OrLater) {
                AbstractSoftwareProcessSshDriver.log.warn("32-bit binaries for Couchbase might not be available, when deploying " + this.context);
            }
            String arch = !this.is64bit ? "x86" : (!this.isRpm && this.isV3OrLater ? "amd64" : "x86_64");
            String string = fileExtension = this.isRpm ? ".rpm" : ".deb";
            if (this.isV3OrLater) {
                return family + arch + fileExtension;
            }
            return arch + fileExtension;
        }

        public String getOsTagWithPrefix() {
            return (!this.isV3OrLater ? "_" : "-") + this.getOsTag();
        }
    }
}

