/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.PreferredProviderHeader;
import org.apache.aries.subsystem.core.archive.PreferredProviderRequirement;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.RepositoryServiceRepository;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;

public class PreferredProviderRepository
implements Repository {
    private boolean initialized;
    private final Repository localRepository;
    private final Repository repositoryServiceRepository = new RepositoryServiceRepository();
    private final SubsystemResource resource;
    private final Collection<Resource> resources = new HashSet<Resource>();
    private final Repository systemRepository = Activator.getInstance().getSystemRepository();

    public PreferredProviderRepository(SubsystemResource resource) {
        this.resource = resource;
        this.localRepository = resource.getLocalRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        PreferredProviderRepository preferredProviderRepository = this;
        synchronized (preferredProviderRepository) {
            if (!this.initialized) {
                this.initialize();
            }
        }
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement requirement : requirements) {
            result.put(requirement, this.findProviders(requirement));
        }
        return result;
    }

    private boolean addLocalRepositoryProviders(Requirement requirement) {
        return this.addProviders(requirement, this.localRepository, false);
    }

    private boolean addProviders(Requirement requirement, Repository repository, boolean checkValid) {
        Map<Requirement, Collection<Capability>> map = repository.findProviders(Collections.singleton(requirement));
        Collection<Capability> capabilities = map.get(requirement);
        if (capabilities == null || capabilities.isEmpty()) {
            return false;
        }
        for (Capability capability : map.get(requirement)) {
            if (checkValid && !this.isValid(capability)) continue;
            this.resources.add(capability.getResource());
        }
        return true;
    }

    private boolean addRepositoryServiceProviders(Requirement requirement) {
        return this.addProviders(requirement, this.repositoryServiceRepository, false);
    }

    private boolean addSystemRepositoryProviders(Requirement requirement) {
        return this.addProviders(requirement, this.systemRepository, true);
    }

    private Collection<Capability> findProviders(Requirement requirement) {
        ArrayList<Capability> result = new ArrayList<Capability>(this.resources.size());
        for (Resource resource : this.resources) {
            for (Capability capability : resource.getCapabilities(requirement.getNamespace())) {
                if (!ResourceHelper.matches(requirement, capability)) continue;
                result.add(capability);
            }
        }
        result.trimToSize();
        return result;
    }

    private void initialize() {
        PreferredProviderHeader header = this.resource.getSubsystemManifest().getPreferredProviderHeader();
        if (header == null) {
            return;
        }
        List<PreferredProviderRequirement> requirements = header.toRequirements(this.resource);
        for (PreferredProviderRequirement requirement : requirements) {
            if (this.addSystemRepositoryProviders(requirement) || this.addLocalRepositoryProviders(requirement)) continue;
            this.addRepositoryServiceProviders(requirement);
        }
    }

    private boolean isValid(Capability capability) {
        for (BasicSubsystem parent : this.resource.getParents()) {
            for (Resource constituent : parent.getConstituents()) {
                if (!ResourceHelper.areEqual(constituent, capability.getResource())) continue;
                return true;
            }
        }
        return false;
    }
}

