/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ImportedService;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ModelledResourceManager;
import org.apache.aries.application.modelling.ModellerException;
import org.apache.aries.subsystem.core.archive.BundleSymbolicNameHeader;
import org.apache.aries.subsystem.core.archive.BundleVersionHeader;
import org.apache.aries.subsystem.core.archive.ExportPackageHeader;
import org.apache.aries.subsystem.core.archive.ImportPackageHeader;
import org.apache.aries.subsystem.core.archive.ProvideBundleCapability;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityCapability;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityHeader;
import org.apache.aries.subsystem.core.archive.RequireBundleHeader;
import org.apache.aries.subsystem.core.archive.RequireBundleRequirement;
import org.apache.aries.subsystem.core.archive.RequireCapabilityHeader;
import org.apache.aries.subsystem.core.archive.RequireCapabilityRequirement;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicCapability;
import org.apache.aries.subsystem.core.internal.BasicRequirement;
import org.apache.aries.subsystem.core.internal.OsgiIdentityCapability;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.io.IOUtils;
import org.apache.aries.util.manifest.BundleManifest;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.RepositoryContent;
import org.osgi.service.subsystem.SubsystemException;

public class BundleResource
implements Resource,
RepositoryContent {
    private final List<Capability> capabilities = new ArrayList<Capability>();
    private final IFile content;
    private final org.apache.aries.subsystem.core.archive.BundleManifest manifest;
    private final List<Requirement> requirements = new ArrayList<Requirement>();

    private static org.apache.aries.subsystem.core.archive.BundleManifest computeManifest(IDirectory directory) {
        return new org.apache.aries.subsystem.core.archive.BundleManifest(BundleManifest.fromBundle((IFile)directory).getRawManifest());
    }

    public BundleResource(IFile content) throws ModellerException {
        this.content = content;
        IDirectory dir = content.isDirectory() ? content.convert() : content.convertNested();
        this.manifest = BundleResource.computeManifest(dir);
        ModelledResource resource = this.getModelledResourceManager().getModelledResource(dir);
        this.computeRequirements(resource);
        this.computeCapabilities(resource);
    }

    public List<Capability> getCapabilities(String namespace) {
        if (namespace == null) {
            return Collections.unmodifiableList(this.capabilities);
        }
        ArrayList<Capability> result = new ArrayList<Capability>(this.capabilities.size());
        for (Capability capability : this.capabilities) {
            if (!namespace.equals(capability.getNamespace())) continue;
            result.add(capability);
        }
        result.trimToSize();
        return Collections.unmodifiableList(result);
    }

    public String getLocation() {
        return this.getFileName(this.content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getContent() {
        try {
            if (this.content.isFile()) {
                return this.content.open();
            }
            try {
                return this.content.open();
            }
            catch (UnsupportedOperationException e) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                JarOutputStream out = new JarOutputStream((OutputStream)baos, this.manifest.getManifest());
                try {
                    this.jar(out, "", this.content.convert());
                }
                finally {
                    IOUtils.close((Closeable)out);
                }
                return new ByteArrayInputStream(baos.toByteArray());
            }
        }
        catch (Exception e) {
            throw new SubsystemException(e);
        }
    }

    public List<Requirement> getRequirements(String namespace) {
        if (namespace == null) {
            return Collections.unmodifiableList(this.requirements);
        }
        ArrayList<Requirement> result = new ArrayList<Requirement>(this.requirements.size());
        for (Requirement requirement : this.requirements) {
            if (!namespace.equals(requirement.getNamespace())) continue;
            result.add(requirement);
        }
        result.trimToSize();
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return this.content.toString();
    }

    private void computeCapabilities(ModelledResource resource) {
        this.computeOsgiIdentityCapability();
        this.computeOsgiWiringPackageCapabilities();
        this.computeOsgiWiringBundleCapability();
        this.computeGenericCapabilities();
        this.computeOsgiServiceCapabilities(resource);
    }

    private void computeGenericCapabilities() {
        ProvideCapabilityHeader pch = (ProvideCapabilityHeader)this.manifest.getHeader("Provide-Capability");
        if (pch != null) {
            for (ProvideCapabilityHeader.Clause clause : pch.getClauses()) {
                this.capabilities.add(new ProvideCapabilityCapability(clause, this));
            }
        }
    }

    private void computeGenericRequirements() {
        RequireCapabilityHeader rch = (RequireCapabilityHeader)this.manifest.getHeader("Require-Capability");
        if (rch != null) {
            for (RequireCapabilityHeader.Clause clause : rch.getClauses()) {
                this.requirements.add(new RequireCapabilityRequirement(clause, this));
            }
        }
    }

    private void computeOsgiIdentityCapability() {
        this.capabilities.add(new OsgiIdentityCapability((Resource)this, this.manifest));
    }

    private void computeOsgiServiceCapabilities(ModelledResource resource) {
        Collection services = resource.getExportedServices();
        for (ExportedService service : services) {
            this.capabilities.add(new BasicCapability.Builder().namespace("osgi.service").attribute("objectClass", new ArrayList(service.getInterfaces())).attributes(service.getServiceProperties()).resource(this).build());
        }
    }

    private void computeOsgiServiceRequirements(ModelledResource resource) {
        Collection services = resource.getImportedServices();
        for (ImportedService service : services) {
            StringBuilder builder = new StringBuilder("(&(").append("objectClass").append('=').append(service.getInterface()).append(')');
            String filter = service.getFilter();
            if (filter != null) {
                builder.append(filter);
            }
            builder.append(')');
            this.requirements.add(new BasicRequirement.Builder().namespace("osgi.service").directive("filter", builder.toString()).directive("resolution", service.isOptional() ? "optional" : "mandatory").directive("cardinality", service.isMultiple() ? "multiple" : "single").resource(this).build());
        }
    }

    private void computeOsgiWiringBundleCapability() {
        BundleSymbolicNameHeader bsnh = (BundleSymbolicNameHeader)this.manifest.getHeader("Bundle-SymbolicName");
        BundleVersionHeader bvh = (BundleVersionHeader)this.manifest.getHeader("Bundle-Version");
        this.capabilities.add(new ProvideBundleCapability(bsnh, bvh, this));
    }

    private void computeOsgiWiringBundleRequirements() {
        RequireBundleHeader rbh = (RequireBundleHeader)this.manifest.getHeader("Require-Bundle");
        if (rbh != null) {
            for (RequireBundleHeader.Clause clause : rbh.getClauses()) {
                this.requirements.add(new RequireBundleRequirement(clause, this));
            }
        }
    }

    private void computeOsgiWiringPackageCapabilities() {
        ExportPackageHeader eph = (ExportPackageHeader)this.manifest.getHeader("Export-Package");
        if (eph != null) {
            this.capabilities.addAll(eph.toCapabilities(this));
        }
    }

    private void computeOsgiWiringPackageRequirements() {
        ImportPackageHeader iph = (ImportPackageHeader)this.manifest.getHeader("Import-Package");
        if (iph != null) {
            this.requirements.addAll(iph.toRequirements(this));
        }
    }

    private void computeRequirements(ModelledResource resource) {
        this.computeOsgiWiringPackageRequirements();
        this.computeGenericRequirements();
        this.computeOsgiWiringBundleRequirements();
        this.computeOsgiServiceRequirements(resource);
    }

    private String getFileName(IFile file) {
        int index;
        String name = file.getName();
        if ("".equals(name)) {
            try {
                name = file.toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new SubsystemException(e);
            }
        }
        if ((index = name.lastIndexOf(47)) == -1 || index == name.length() - 1) {
            return name;
        }
        return name.substring(index + 1);
    }

    private ModelledResourceManager getModelledResourceManager() {
        return Activator.getInstance().getModelledResourceManager();
    }

    private void jar(JarOutputStream out, String prefix, IDirectory directory) throws IOException {
        List files = directory.listFiles();
        for (IFile f : files) {
            String fileName = f.isDirectory() ? prefix + this.getFileName(f) + "/" : prefix + this.getFileName(f);
            if ("META-INF/".equalsIgnoreCase(fileName) || "META-INF/MANIFEST.MF".equalsIgnoreCase(fileName)) continue;
            JarEntry entry = new JarEntry(fileName);
            entry.setSize(f.getSize());
            entry.setTime(f.getLastModified());
            out.putNextEntry(entry);
            if (f.isDirectory()) {
                this.jar(out, fileName, f.convert());
                continue;
            }
            IOUtils.copy((InputStream)f.open(), (OutputStream)out);
        }
    }
}

